# Readme

The .NET bridge API is a wrapper for the .NET programming language that uses an actual i-net PDFC server to carry out the file comparison. The bridge API starts a Java process running the product in the background. It will then operate as a bridge to this process.

## System Requirements

The bridge API is able to run on any OS with .NET runtime and Java runtime installed. There is no limit to a 32 bit or 64 bit architecture. The .NET and the Java process don't need to use the same architecture.

### Required Folder Structure for Visual Studio and Powershell

```make
<project folder>\                       # the root of your Visual Studio project
  <any folder>\                         # the location of this folder is not important, it must be a sub folder of the project or the root
    inetsoftware.Pdfc.dll               # the reference must be added to the Visual Studio project
  plugins\
    pdfc.zip                            # basic PDFC API
    processbridge.zip                   # base process bridge API
    processbridge.pdfc.zip              # pdfc specific bridge API
    parser.pdf.zip                      # parsing of pdf files
    reporting.zip                       # generation of pdf output
    htmlengine.zip                      # required by reporting plugin
    *.zip                               # any further feature you want to use
  java\
    inetcore.jar                        # basic platform API
    *.jar                               # more optional features
  lang\                                 # language files for the OCR filter
    tessdata\
       eng.traineddata                  # default language for ORC, required if OCR filter is used                
  jre\                                  # optional Java runtime, if not available the Java VM of the system is used
    bin\                              
      java.exe                          # it looks for this file to find the optional Java runtime
      *.*                               # all Java VM files
    lib\*.*
    *.*
```

## Visual Studio

If you want to test this API with Visual Studio or Rider then:

  * Create a new project, for example a console application
  * Add the files described in the folder structure below to the project
  * Add a reference to the library inetsoftware.Pdfc.dll
  * Add a sample *.cs file to the project
  * Build the project and run it. The samples\\resources\\ folder contains sample PDF files

## Powershell

If you're running any of the provided powershell script you might need to [prepare your environment](#required-folder-structure-for-visual-studio-and-powershell). Powershell scripts are disabled by default. Here is what you need to do:

```powershell
# activate powershell scripting temporarily
powershell.exe -ExecutionPolicy Unrestricted

# go into previously created folder (please modify accordingly)
cd <project folder>\<any folder>

# execute script
& '<sdk>\Documentation and Samples\dotnet - Samples\PowerShell\ComparePdfFiles.ps1'
```

